using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

namespace MutexSample
{
   class Program
   {
      static int sharedNumber = 42;
      static Mutex localMut = new Mutex();
      static bool isNew;
      static Mutex globalMut = new Mutex(true, "Globalna blokada muteks", out isNew);

      static void Main(string[] args)
      {
         if (!isNew)
         {
            Console.WriteLine("Ta aplikacja zostaa ju uruchomiona, nastpuje wyczenie dodatkowej instancji...");
            return;
         }

         // dodatkowe wygenerowanie grupy wtkw w celu przeprowadzenia operacji na wspdzielonych zasobach
         Thread[] workers = new Thread[20];
         for (int i = 0; i < 20; i++)
         {
            Thread worker = new Thread(new ThreadStart(DoWork));
            workers[i] = worker;
            worker.Start();
         }

         foreach (Thread workerThread in workers)
            workerThread.Join();
         Console.WriteLine("Caa praca zakoczona, nowa warto wspdzielonego zasobu to {0}", sharedNumber);
         Console.ReadLine();
         globalMut.ReleaseMutex();
      }

      static void DoWork()
      {
         // wtek roboczy oczekuje na uzyskanie dostpu do wspdzielonego zasobu
         localMut.WaitOne();

         // modyfikacja wspdzielonych zasobw
         // kilka modyfikujcych linii kodu, w celu wykazania prawidowego stanu danych w ramach bloku chronionego przez muteks
         Console.WriteLine("Uzyskuj dostp do chronionego zasobu...");
         sharedNumber += 2;
         sharedNumber -= 1;

         localMut.ReleaseMutex();
      }
   }
}
